!!ARBvp1.0
# watertest4__NOCOLOR.vsh

TEMP r0, r1, r2;
PARAM c[11] = { program.env[0..10] };
PARAM c20 = program.env[20];

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.texcoord[0];

PARAM c16 = { 0.0, 1.0, 0.0, 0.0 };   # Up vector in game world space
PARAM c17 = { 1.0, 1.0, 1.0, 1.0 };   # 1 for inverting

ALIAS oPos = result.position;
ALIAS oD0 = result.color.primary;
ALIAS oD1 = result.color.secondary;
ALIAS oT0 = result.texcoord[0];
ALIAS oT1 = result.texcoord[1];


# transform position
DP4 oPos.x, v0, c[0];
DP4 oPos.y, v0, c[1];
DP4 oPos.z, v0, c[2];
DP4 oPos.w, v0, c[3];

# NOCOLOR texture coords
MOV oT0, v1;

# Transform eye vector (from 0 to cam-space vertex) to world space
DP4 r1.x, v0, c[4];
DP4 r1.y, v0, c[5];
DP4 r1.z, v0, c[6];
DP4 r1.w, v0, c[7];

DP3 r2.x, -r1, c[8];
DP3 r2.y, -r1, c[9];
DP3 r2.z, -r1, c[10];

# Normalize
DP3 r2.w, r2, r2;
RSQ r2.w, r2.w;
MUL r2, r2, r2.w;

# Put world space eye-to-vert vector in T1
MOV oT1.xyz, r2;

# Calculate per-vertex Fresnel term
DP3 r2, r2, c16;				# Eye dot N
SUB r2, c17, r2;				# 1 - E.N
MUL r2, r2, r2;					# (1 - E.N)^2
MAD oD1, r2.x, c20.x, c20.y;	# Bias + Scale * (1 - E.N)^2

END
